within Modelica_DeviceDrivers.EmbeddedTargets.STM32F4.Examples.STM32F4_Discovery;
model BlinkSpringMass
  "Blink example driven by position sensor of continuous-time spring-mass system"
  extends .Modelica.Icons.Example;
  import Modelica_DeviceDrivers.EmbeddedTargets.STM32F4;
  inner Modelica_DeviceDrivers.EmbeddedTargets.STM32F4.Blocks.Microcontroller mcu(desiredPeriod = 0.01, platform = Modelica_DeviceDrivers.EmbeddedTargets.STM32F4.Types.Platform.STM32F4DISC)
  annotation(Placement(visible = true, transformation(origin={-54,52},    extent={{-10,-10},
            {10,10}},                                                                                      rotation = 0)));
 // STM32F4.Functions.HAL.Init HALinit = STM32F4.Functions.HAL.Init();
  Blocks.Led led(led = Modelica_DeviceDrivers.EmbeddedTargets.STM32F4.Types.LED.LED3)  annotation(Placement(visible = true, transformation(origin={-22,14},  extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Blocks.SynchronizeRealtime synchronizeRealtime(ahbPre = Modelica_DeviceDrivers.EmbeddedTargets.STM32F4.Types.AHBPre.DIV_1, apb1Pre = Modelica_DeviceDrivers.EmbeddedTargets.STM32F4.Types.APBPre.DIV_4, apb2Pre = Modelica_DeviceDrivers.EmbeddedTargets.STM32F4.Types.APBPre.DIV_2, clock = Modelica_DeviceDrivers.EmbeddedTargets.STM32F4.Types.Clock.HSE_PLL, overdrive = false, pllM = 8, pllN = 336, pllP = Modelica_DeviceDrivers.EmbeddedTargets.STM32F4.Types.PLLP.DIV_2, pllQ = 7, preFlash = true, pwrRegVoltage = Modelica_DeviceDrivers.EmbeddedTargets.STM32F4.Types.PWRRegulatorVoltage.SCALE1)  annotation (
    Placement(visible = true, transformation(origin={-22,52},   extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Mechanics.Translational.Components.Fixed fixed
    annotation (Placement(transformation(extent={{-92,2},{-72,22}})));
  Modelica.Mechanics.Translational.Sensors.PositionSensor positionSensor
    annotation (Placement(transformation(extent={{-68,20},{-48,40}})));
  Modelica.Mechanics.Translational.Components.Spring spring(
    s_rel(start=0.2),
    s_rel0=0.1,
    c=10) annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={-82,26})));
  Modelica.Mechanics.Translational.Components.Mass mass(m=1) annotation (
      Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={-82,50})));
  Modelica.Blocks.Logical.GreaterThreshold greaterThreshold(threshold=0.1)
    annotation (Placement(transformation(extent={{-48,10},{-40,18}})));
equation
             /* synchronizeRealtime1.actualInterval is not legal in experiment annotation*/
  connect(spring.flange_a, fixed.flange)
    annotation (Line(points={{-82,16},{-82,12}}, color={0,127,0}));
  connect(mass.flange_a, spring.flange_b)
    annotation (Line(points={{-82,40},{-82,36}}, color={0,127,0}));
  connect(positionSensor.s, greaterThreshold.u) annotation (Line(points={{-47,30},
          {-44,30},{-44,20},{-52,20},{-52,14},{-48.8,14}}, color={0,0,127}));
  connect(greaterThreshold.y, led.u)
    annotation (Line(points={{-39.6,14},{-34,14}}, color={255,0,255}));
  connect(mass.flange_b, positionSensor.flange) annotation (Line(points={{-82,60},
          {-70,60},{-70,30},{-68,30}}, color={0,127,0}));
  annotation (                                                                             Experiment(Interval = 0.01), Documentation(info="<html>
<h4>BlinkSpringMass</h4>
<p>BlinkSpringMass is a variant of the Blink example in which
the toggling signal is generated by monitoring the position of the mass in a continuous-time spring-mass system.</p>
</html>"));
end BlinkSpringMass;
